<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ServiceScheduleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/serviceschedulelist[/{id}]", [PermissionMiddleware::class], "list.service_schedule")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/servicescheduleadd[/{id}]", [PermissionMiddleware::class], "add.service_schedule")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/servicescheduleview[/{id}]", [PermissionMiddleware::class], "view.service_schedule")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/servicescheduleedit[/{id}]", [PermissionMiddleware::class], "edit.service_schedule")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/servicescheduledelete[/{id}]", [PermissionMiddleware::class], "delete.service_schedule")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/serviceschedulesearch", [PermissionMiddleware::class], "search.service_schedule")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/serviceschedulequery", [PermissionMiddleware::class], "query.service_schedule")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceScheduleSearch", "ServiceScheduleQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/serviceschedulepreview", [PermissionMiddleware::class], "preview.service_schedule")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceSchedulePreview", null, false);
    }
}
