<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ServiceRequestController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/servicerequestlist[/{id}]", [PermissionMiddleware::class], "list.service_request")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/servicerequestadd[/{id}]", [PermissionMiddleware::class], "add.service_request")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/servicerequestview[/{id}]", [PermissionMiddleware::class], "view.service_request")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/servicerequestedit[/{id}]", [PermissionMiddleware::class], "edit.service_request")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/servicerequestdelete[/{id}]", [PermissionMiddleware::class], "delete.service_request")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/servicerequestsearch", [PermissionMiddleware::class], "search.service_request")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceRequestSearch");
    }
}
