<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ServiceReportController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/servicereportlist[/{id}]", [PermissionMiddleware::class], "list.service_report")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/servicereportadd[/{id}]", [PermissionMiddleware::class], "add.service_report")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/servicereportview[/{id}]", [PermissionMiddleware::class], "view.service_report")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/servicereportedit[/{id}]", [PermissionMiddleware::class], "edit.service_report")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/servicereportdelete[/{id}]", [PermissionMiddleware::class], "delete.service_report")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/servicereportsearch", [PermissionMiddleware::class], "search.service_report")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ServiceReportSearch");
    }
}
