<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleRequestStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplerequeststatuslist[/{id}]", [PermissionMiddleware::class], "list.sample_request_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/samplerequeststatusadd[/{id}]", [PermissionMiddleware::class], "add.sample_request_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplerequeststatusview[/{id}]", [PermissionMiddleware::class], "view.sample_request_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplerequeststatusedit[/{id}]", [PermissionMiddleware::class], "edit.sample_request_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestStatusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/samplerequeststatusdelete[/{id}]", [PermissionMiddleware::class], "delete.sample_request_status")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestStatusDelete");
    }
}
