<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleRequestReceiveController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplerequestreceivelist[/{id}]", [PermissionMiddleware::class], "list.sample_request_receive")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestReceiveList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/samplerequestreceiveadd[/{id}]", [PermissionMiddleware::class], "add.sample_request_receive")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestReceiveAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplerequestreceiveview[/{id}]", [PermissionMiddleware::class], "view.sample_request_receive")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestReceiveView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplerequestreceiveedit[/{id}]", [PermissionMiddleware::class], "edit.sample_request_receive")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestReceiveEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/samplerequestreceivedelete[/{id}]", [PermissionMiddleware::class], "delete.sample_request_receive")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleRequestReceiveDelete");
    }
}
