<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqMiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqmisclist[/{id}]", [PermissionMiddleware::class], "list.sample_req_misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscadd[/{id}]", [PermissionMiddleware::class], "add.sample_req_misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscaddopt", [PermissionMiddleware::class], "addopt.sample_req_misc")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscview[/{id}]", [PermissionMiddleware::class], "view.sample_req_misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscdelete[/{id}]", [PermissionMiddleware::class], "delete.sample_req_misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqmiscsearch", [PermissionMiddleware::class], "search.sample_req_misc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqMiscSearch");
    }
}
