<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqlist[/{id}]", [PermissionMiddleware::class], "list.sample_req")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/samplereqadd[/{id}]", [PermissionMiddleware::class], "add.sample_req")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqview[/{id}]", [PermissionMiddleware::class], "view.sample_req")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/samplereqdelete[/{id}]", [PermissionMiddleware::class], "delete.sample_req")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqDelete");
    }
}
