<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqCartPreDispatchController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpredispatchlist[/{id}]", [PermissionMiddleware::class], "list.sample_req_cart_pre_dispatch")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPreDispatchList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpredispatchview[/{id}]", [PermissionMiddleware::class], "view.sample_req_cart_pre_dispatch")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPreDispatchView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpredispatchedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_cart_pre_dispatch")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPreDispatchEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpredispatchsearch", [PermissionMiddleware::class], "search.sample_req_cart_pre_dispatch")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPreDispatchSearch");
    }
}
