<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqCartPoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpolist[/{id}]", [PermissionMiddleware::class], "list.sample_req_cart_po")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPoList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpoview[/{id}]", [PermissionMiddleware::class], "view.sample_req_cart_po")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartpoedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_cart_po")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPoEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartposearch", [PermissionMiddleware::class], "search.sample_req_cart_po")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartPoSearch");
    }
}
