<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqCartDispatchController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdispatchlist[/{id}]", [PermissionMiddleware::class], "list.sample_req_cart_dispatch")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDispatchList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdispatchview[/{id}]", [PermissionMiddleware::class], "view.sample_req_cart_dispatch")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDispatchView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdispatchedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_cart_dispatch")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDispatchEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdispatchupdate", [PermissionMiddleware::class], "update.sample_req_cart_dispatch")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDispatchUpdate");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdispatchsearch", [PermissionMiddleware::class], "search.sample_req_cart_dispatch")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDispatchSearch");
    }
}
