<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqCartController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartlist[/{id}]", [PermissionMiddleware::class], "list.sample_req_cart")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartadd[/{id}]", [PermissionMiddleware::class], "add.sample_req_cart")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartaddopt", [PermissionMiddleware::class], "addopt.sample_req_cart")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartview[/{id}]", [PermissionMiddleware::class], "view.sample_req_cart")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_cart")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartdelete[/{id}]", [PermissionMiddleware::class], "delete.sample_req_cart")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartsearch", [PermissionMiddleware::class], "search.sample_req_cart")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartSearch");
    }
}
