<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SampleReqCartAppController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartapplist[/{id}]", [PermissionMiddleware::class], "list.sample_req_cart_app")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAppList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartappview[/{id}]", [PermissionMiddleware::class], "view.sample_req_cart_app")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAppView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartappedit[/{id}]", [PermissionMiddleware::class], "edit.sample_req_cart_app")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAppEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/samplereqcartappsearch", [PermissionMiddleware::class], "search.sample_req_cart_app")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SampleReqCartAppSearch");
    }
}
