<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SalaryPaymentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentlist[/{id}]", [PermissionMiddleware::class], "list.salary_payment")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentadd[/{id}]", [PermissionMiddleware::class], "add.salary_payment")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentview[/{id}]", [PermissionMiddleware::class], "view.salary_payment")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentedit[/{id}]", [PermissionMiddleware::class], "edit.salary_payment")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentdelete[/{id}]", [PermissionMiddleware::class], "delete.salary_payment")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/salarypaymentsearch", [PermissionMiddleware::class], "search.salary_payment")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryPaymentSearch");
    }
}
