<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SalaryExpensesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/salaryexpenseslist[/{id}]", [PermissionMiddleware::class], "list.salary_expenses")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/salaryexpensesadd[/{id}]", [PermissionMiddleware::class], "add.salary_expenses")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/salaryexpensesview[/{id}]", [PermissionMiddleware::class], "view.salary_expenses")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/salaryexpensesedit[/{id}]", [PermissionMiddleware::class], "edit.salary_expenses")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/salaryexpensesdelete[/{id}]", [PermissionMiddleware::class], "delete.salary_expenses")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/salaryexpensessearch", [PermissionMiddleware::class], "search.salary_expenses")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SalaryExpensesSearch");
    }
}
