<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SStudentListController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sstudentlistlist[/{id}]", [PermissionMiddleware::class], "list.s_student_list")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SStudentListList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sstudentlistsearch", [PermissionMiddleware::class], "search.s_student_list")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SStudentListSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sstudentlistquery", [PermissionMiddleware::class], "query.s_student_list")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SStudentListSearch", "SStudentListQuery");
    }
}
