<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SPersonalInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfolist[/{id}]", [PermissionMiddleware::class], "list.s_personal_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoadd[/{id}]", [PermissionMiddleware::class], "add.s_personal_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoaddopt", [PermissionMiddleware::class], "addopt.s_personal_info")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoview[/{id}]", [PermissionMiddleware::class], "view.s_personal_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoedit[/{id}]", [PermissionMiddleware::class], "edit.s_personal_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoupdate", [PermissionMiddleware::class], "update.s_personal_info")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfodelete[/{id}]", [PermissionMiddleware::class], "delete.s_personal_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfosearch", [PermissionMiddleware::class], "search.s_personal_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/spersonalinfoquery", [PermissionMiddleware::class], "query.s_personal_info")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoSearch", "SPersonalInfoQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/spersonalinfopreview", [PermissionMiddleware::class], "preview.s_personal_info")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SPersonalInfoPreview", null, false);
    }
}
