<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SOmrValueController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/somrvaluelist[/{id}]", [PermissionMiddleware::class], "list.s_omr_value")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/somrvalueadd[/{id}]", [PermissionMiddleware::class], "add.s_omr_value")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/somrvalueview[/{id}]", [PermissionMiddleware::class], "view.s_omr_value")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/somrvalueedit[/{id}]", [PermissionMiddleware::class], "edit.s_omr_value")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/somrvaluedelete[/{id}]", [PermissionMiddleware::class], "delete.s_omr_value")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/somrvaluesearch", [PermissionMiddleware::class], "search.s_omr_value")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SOmrValueSearch");
    }
}
