<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SInoutTimeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sinouttimelist[/{id}]", [PermissionMiddleware::class], "list.s_inout_time")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SInoutTimeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sinouttimeadd[/{id}]", [PermissionMiddleware::class], "add.s_inout_time")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SInoutTimeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sinouttimeview[/{id}]", [PermissionMiddleware::class], "view.s_inout_time")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SInoutTimeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sinouttimeedit[/{id}]", [PermissionMiddleware::class], "edit.s_inout_time")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SInoutTimeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sinouttimedelete[/{id}]", [PermissionMiddleware::class], "delete.s_inout_time")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SInoutTimeDelete");
    }
}
