<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SFacultyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sfacultylist[/{id}]", [PermissionMiddleware::class], "list.s_faculty")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sfacultyadd[/{id}]", [PermissionMiddleware::class], "add.s_faculty")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultyAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sfacultyview[/{id}]", [PermissionMiddleware::class], "view.s_faculty")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultyView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sfacultyedit[/{id}]", [PermissionMiddleware::class], "edit.s_faculty")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultyEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sfacultydelete[/{id}]", [PermissionMiddleware::class], "delete.s_faculty")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultyDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sfacultysearch", [PermissionMiddleware::class], "search.s_faculty")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultySearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sfacultyquery", [PermissionMiddleware::class], "query.s_faculty")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SFacultySearch", "SFacultyQuery");
    }
}
