<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SEvalSchemeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sevalschemelist[/{id}]", [PermissionMiddleware::class], "list.s_eval_scheme")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEvalSchemeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sevalschemeadd[/{id}]", [PermissionMiddleware::class], "add.s_eval_scheme")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEvalSchemeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sevalschemeview[/{id}]", [PermissionMiddleware::class], "view.s_eval_scheme")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEvalSchemeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sevalschemeedit[/{id}]", [PermissionMiddleware::class], "edit.s_eval_scheme")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEvalSchemeEdit");
    }
}
