<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SEpcLiveController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sepclivelist[/{id}]", [PermissionMiddleware::class], "list.s_epc_live")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sepcliveadd[/{id}]", [PermissionMiddleware::class], "add.s_epc_live")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sepcliveview[/{id}]", [PermissionMiddleware::class], "view.s_epc_live")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sepcliveedit[/{id}]", [PermissionMiddleware::class], "edit.s_epc_live")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sepclivedelete[/{id}]", [PermissionMiddleware::class], "delete.s_epc_live")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sepclivesearch", [PermissionMiddleware::class], "search.s_epc_live")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sepclivequery", [PermissionMiddleware::class], "query.s_epc_live")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcLiveSearch", "SEpcLiveQuery");
    }
}
