<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SEpcDataController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sepcdatalist[/{id}]", [PermissionMiddleware::class], "list.s_epc_data")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sepcdataadd[/{id}]", [PermissionMiddleware::class], "add.s_epc_data")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sepcdataview[/{id}]", [PermissionMiddleware::class], "view.s_epc_data")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sepcdataedit[/{id}]", [PermissionMiddleware::class], "edit.s_epc_data")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sepcdatadelete[/{id}]", [PermissionMiddleware::class], "delete.s_epc_data")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sepcdatasearch", [PermissionMiddleware::class], "search.s_epc_data")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sepcdataquery", [PermissionMiddleware::class], "query.s_epc_data")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcDataSearch", "SEpcDataQuery");
    }
}
