<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SEpcBackupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sepcbackuplist[/{id}]", [PermissionMiddleware::class], "list.s_epc_backup")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupadd[/{id}]", [PermissionMiddleware::class], "add.s_epc_backup")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupview[/{id}]", [PermissionMiddleware::class], "view.s_epc_backup")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupedit[/{id}]", [PermissionMiddleware::class], "edit.s_epc_backup")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupdelete[/{id}]", [PermissionMiddleware::class], "delete.s_epc_backup")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupsearch", [PermissionMiddleware::class], "search.s_epc_backup")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sepcbackupquery", [PermissionMiddleware::class], "query.s_epc_backup")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SEpcBackupSearch", "SEpcBackupQuery");
    }
}
