<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SAttendanceInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sattendanceinfolist[/{id}]", [PermissionMiddleware::class], "list.s_attendance_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAttendanceInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sattendanceinfoadd[/{id}]", [PermissionMiddleware::class], "add.s_attendance_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAttendanceInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sattendanceinfoview[/{id}]", [PermissionMiddleware::class], "view.s_attendance_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAttendanceInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sattendanceinfoedit[/{id}]", [PermissionMiddleware::class], "edit.s_attendance_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAttendanceInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sattendanceinfodelete[/{id}]", [PermissionMiddleware::class], "delete.s_attendance_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAttendanceInfoDelete");
    }
}
