<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class SAdmissionInfoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfolist[/{id}]", [PermissionMiddleware::class], "list.s_admission_info")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfoadd[/{id}]", [PermissionMiddleware::class], "add.s_admission_info")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfoview[/{id}]", [PermissionMiddleware::class], "view.s_admission_info")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfoedit[/{id}]", [PermissionMiddleware::class], "edit.s_admission_info")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfodelete[/{id}]", [PermissionMiddleware::class], "delete.s_admission_info")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfosearch", [PermissionMiddleware::class], "search.s_admission_info")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/sadmissioninfoquery", [PermissionMiddleware::class], "query.s_admission_info")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoSearch", "SAdmissionInfoQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/sadmissioninfopreview", [PermissionMiddleware::class], "preview.s_admission_info")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SAdmissionInfoPreview", null, false);
    }
}
