<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RequestTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/requesttypelist[/{id}]", [PermissionMiddleware::class], "list.request_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/requesttypeadd[/{id}]", [PermissionMiddleware::class], "add.request_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/requesttypeview[/{id}]", [PermissionMiddleware::class], "view.request_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/requesttypeedit[/{id}]", [PermissionMiddleware::class], "edit.request_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/requesttypedelete[/{id}]", [PermissionMiddleware::class], "delete.request_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestTypeDelete");
    }
}
