<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RequestGroupController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/requestgrouplist", [PermissionMiddleware::class], "list.request_group")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestGroupList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/requestgroupadd", [PermissionMiddleware::class], "add.request_group")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestGroupAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/requestgroupsearch", [PermissionMiddleware::class], "search.request_group")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RequestGroupSearch");
    }
}
