<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class Request2Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/request2list[/{id}]", [PermissionMiddleware::class], "list.request2")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Request2List");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/request2add[/{id}]", [PermissionMiddleware::class], "add.request2")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Request2Add");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/request2view[/{id}]", [PermissionMiddleware::class], "view.request2")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Request2View");
    }
}
