<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RentalPoController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/rentalpolist[/{id}]", [PermissionMiddleware::class], "list.rental_po")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/rentalpoadd[/{id}]", [PermissionMiddleware::class], "add.rental_po")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/rentalpoview[/{id}]", [PermissionMiddleware::class], "view.rental_po")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/rentalpoedit[/{id}]", [PermissionMiddleware::class], "edit.rental_po")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/rentalpodelete[/{id}]", [PermissionMiddleware::class], "delete.rental_po")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/rentalposearch", [PermissionMiddleware::class], "search.rental_po")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalPoSearch");
    }
}
