<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RentalCartController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/rentalcartlist[/{id}]", [PermissionMiddleware::class], "list.rental_cart")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalCartList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/rentalcartadd[/{id}]", [PermissionMiddleware::class], "add.rental_cart")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalCartAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/rentalcartedit[/{id}]", [PermissionMiddleware::class], "edit.rental_cart")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalCartEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/rentalcartdelete[/{id}]", [PermissionMiddleware::class], "delete.rental_cart")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalCartDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/rentalcartsearch", [PermissionMiddleware::class], "search.rental_cart")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RentalCartSearch");
    }
}
