<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RefreshUpdateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/refreshupdatelist[/{id}]", [PermissionMiddleware::class], "list.refresh_update")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefreshUpdateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/refreshupdateadd[/{id}]", [PermissionMiddleware::class], "add.refresh_update")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefreshUpdateAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/refreshupdateview[/{id}]", [PermissionMiddleware::class], "view.refresh_update")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefreshUpdateView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/refreshupdateedit[/{id}]", [PermissionMiddleware::class], "edit.refresh_update")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefreshUpdateEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/refreshupdatedelete[/{id}]", [PermissionMiddleware::class], "delete.refresh_update")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefreshUpdateDelete");
    }
}
