<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RefImageController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/refimagelist[/{id}]", [PermissionMiddleware::class], "list.ref_image")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefImageList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/refimageview[/{id}]", [PermissionMiddleware::class], "view.ref_image")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefImageView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/refimageedit[/{id}]", [PermissionMiddleware::class], "edit.ref_image")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefImageEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/refimagesearch", [PermissionMiddleware::class], "search.ref_image")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefImageSearch");
    }
}
