<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/reflist[/{id}]", [PermissionMiddleware::class], "list.ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/refadd[/{id}]", [PermissionMiddleware::class], "add.ref")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/refaddopt", [PermissionMiddleware::class], "addopt.ref")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/refview[/{id}]", [PermissionMiddleware::class], "view.ref")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/refedit[/{id}]", [PermissionMiddleware::class], "edit.ref")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/refdelete[/{id}]", [PermissionMiddleware::class], "delete.ref")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/refsearch", [PermissionMiddleware::class], "search.ref")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefSearch");
    }
}
