<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class RefCodeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/refcodelist[/{id}]", [PermissionMiddleware::class], "list.ref_code")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/refcodeadd[/{id}]", [PermissionMiddleware::class], "add.ref_code")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/refcodeview[/{id}]", [PermissionMiddleware::class], "view.ref_code")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/refcodeedit[/{id}]", [PermissionMiddleware::class], "edit.ref_code")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/refcodedelete[/{id}]", [PermissionMiddleware::class], "delete.ref_code")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/refcodesearch", [PermissionMiddleware::class], "search.ref_code")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "RefCodeSearch");
    }
}
