<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ReceiptController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/receiptlist[/{id}]", [PermissionMiddleware::class], "list.receipt")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/receiptadd[/{id}]", [PermissionMiddleware::class], "add.receipt")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/receiptview[/{id}]", [PermissionMiddleware::class], "view.receipt")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/receiptedit[/{id}]", [PermissionMiddleware::class], "edit.receipt")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/receiptdelete[/{id}]", [PermissionMiddleware::class], "delete.receipt")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/receiptsearch", [PermissionMiddleware::class], "search.receipt")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptSearch");
    }
}
