<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class ReceiptBController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/receiptblist[/{id}]", [PermissionMiddleware::class], "list.receipt_b")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptBList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/receiptbadd[/{id}]", [PermissionMiddleware::class], "add.receipt_b")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptBAdd");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/receiptbedit[/{id}]", [PermissionMiddleware::class], "edit.receipt_b")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptBEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/receiptbdelete[/{id}]", [PermissionMiddleware::class], "delete.receipt_b")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptBDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/receiptbsearch", [PermissionMiddleware::class], "search.receipt_b")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ReceiptBSearch");
    }
}
