<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class QcOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/qcoldlist[/{id}]", [PermissionMiddleware::class], "list.qc_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/qcoldadd[/{id}]", [PermissionMiddleware::class], "add.qc_old")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/qcoldview[/{id}]", [PermissionMiddleware::class], "view.qc_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/qcoldedit[/{id}]", [PermissionMiddleware::class], "edit.qc_old")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/qcolddelete[/{id}]", [PermissionMiddleware::class], "delete.qc_old")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/qcoldsearch", [PermissionMiddleware::class], "search.qc_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcOldSearch");
    }
}
