<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class QcItemsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/qcitemslist[/{id}]", [PermissionMiddleware::class], "list.qc_items")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/qcitemsadd[/{id}]", [PermissionMiddleware::class], "add.qc_items")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/qcitemsview[/{id}]", [PermissionMiddleware::class], "view.qc_items")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/qcitemsedit[/{id}]", [PermissionMiddleware::class], "edit.qc_items")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/qcitemsdelete[/{id}]", [PermissionMiddleware::class], "delete.qc_items")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/qcitemssearch", [PermissionMiddleware::class], "search.qc_items")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcItemsSearch");
    }
}
