<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class QcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/qclist[/{id}]", [PermissionMiddleware::class], "list.qc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/qcadd[/{id}]", [PermissionMiddleware::class], "add.qc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/qcview[/{id}]", [PermissionMiddleware::class], "view.qc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/qcedit[/{id}]", [PermissionMiddleware::class], "edit.qc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/qcdelete[/{id}]", [PermissionMiddleware::class], "delete.qc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/qcsearch", [PermissionMiddleware::class], "search.qc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcSearch");
    }
}
