<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class QcAuthorisedController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/qcauthorisedlist[/{id}]", [PermissionMiddleware::class], "list.qc_authorised")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcAuthorisedList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/qcauthorisedview[/{id}]", [PermissionMiddleware::class], "view.qc_authorised")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcAuthorisedView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/qcauthorisededit[/{id}]", [PermissionMiddleware::class], "edit.qc_authorised")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcAuthorisedEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/qcauthorisedsearch", [PermissionMiddleware::class], "search.qc_authorised")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "QcAuthorisedSearch");
    }
}
