<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseRefMonthlyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchaserefmonthlylist", [PermissionMiddleware::class], "list.purchase_ref_monthly")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefMonthlyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/purchaserefmonthlyadd", [PermissionMiddleware::class], "add.purchase_ref_monthly")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefMonthlyAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaserefmonthlysearch", [PermissionMiddleware::class], "search.purchase_ref_monthly")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefMonthlySearch");
    }
}
