<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseRefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchasereflist", [PermissionMiddleware::class], "list.purchase_ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaserefsearch", [PermissionMiddleware::class], "search.purchase_ref")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/purchaserefpreview", [PermissionMiddleware::class], "preview.purchase_ref")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseRefPreview", null, false);
    }
}
