<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseLQcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchaselqclist[/{id}]", [PermissionMiddleware::class], "list.purchase_l_qc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLQcList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaselqcview[/{id}]", [PermissionMiddleware::class], "view.purchase_l_qc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLQcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/purchaselqcedit[/{id}]", [PermissionMiddleware::class], "edit.purchase_l_qc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLQcEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaselqcsearch", [PermissionMiddleware::class], "search.purchase_l_qc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLQcSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/purchaselqcquery", [PermissionMiddleware::class], "query.purchase_l_qc")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLQcSearch", "PurchaseLQcQuery");
    }
}
