<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseLOldController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchaseloldlist[/{id}]", [PermissionMiddleware::class], "list.purchase_l_old")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLOldList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaseloldview[/{id}]", [PermissionMiddleware::class], "view.purchase_l_old")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLOldView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaseloldsearch", [PermissionMiddleware::class], "search.purchase_l_old")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLOldSearch");
    }
}
