<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseLController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchasellist[/{id}]", [PermissionMiddleware::class], "list.purchase_l")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/purchaseladd[/{id}]", [PermissionMiddleware::class], "add.purchase_l")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaselview[/{id}]", [PermissionMiddleware::class], "view.purchase_l")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/purchaseledit[/{id}]", [PermissionMiddleware::class], "edit.purchase_l")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaselsearch", [PermissionMiddleware::class], "search.purchase_l")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLSearch");
    }
}
