<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseLBcController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchaselbclist[/{id}]", [PermissionMiddleware::class], "list.purchase_l_bc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLBcList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/purchaselbcadd[/{id}]", [PermissionMiddleware::class], "add.purchase_l_bc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLBcAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaselbcview[/{id}]", [PermissionMiddleware::class], "view.purchase_l_bc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLBcView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/purchaselbcedit[/{id}]", [PermissionMiddleware::class], "edit.purchase_l_bc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLBcEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaselbcsearch", [PermissionMiddleware::class], "search.purchase_l_bc")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLBcSearch");
    }
}
