<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseLAuditController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchaselauditlist[/{id}]", [PermissionMiddleware::class], "list.purchase_l_audit")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAuditList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/purchaselauditadd[/{id}]", [PermissionMiddleware::class], "add.purchase_l_audit")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAuditAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaselauditview[/{id}]", [PermissionMiddleware::class], "view.purchase_l_audit")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAuditView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/purchaselauditedit[/{id}]", [PermissionMiddleware::class], "edit.purchase_l_audit")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAuditEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaselauditsearch", [PermissionMiddleware::class], "search.purchase_l_audit")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseLAuditSearch");
    }
}
