<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PurchaseAController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/purchasealist[/{id}]", [PermissionMiddleware::class], "list.purchase_a")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseAList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/purchaseaadd[/{id}]", [PermissionMiddleware::class], "add.purchase_a")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseAAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/purchaseaview[/{id}]", [PermissionMiddleware::class], "view.purchase_a")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseAView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/purchaseaedit[/{id}]", [PermissionMiddleware::class], "edit.purchase_a")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseAEdit");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/purchaseasearch", [PermissionMiddleware::class], "search.purchase_a")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PurchaseASearch");
    }
}
