<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PropertyMiscController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/propertymisclist[/{id}]", [PermissionMiddleware::class], "list.property_misc")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyMiscList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/propertymiscadd[/{id}]", [PermissionMiddleware::class], "add.property_misc")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyMiscAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/propertymiscview[/{id}]", [PermissionMiddleware::class], "view.property_misc")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyMiscView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/propertymiscedit[/{id}]", [PermissionMiddleware::class], "edit.property_misc")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyMiscEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/propertymiscdelete[/{id}]", [PermissionMiddleware::class], "delete.property_misc")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyMiscDelete");
    }
}
