<?php

namespace PHPMaker2024\fibre;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\fibre\Attributes\Delete;
use PHPMaker2024\fibre\Attributes\Get;
use PHPMaker2024\fibre\Attributes\Map;
use PHPMaker2024\fibre\Attributes\Options;
use PHPMaker2024\fibre\Attributes\Patch;
use PHPMaker2024\fibre\Attributes\Post;
use PHPMaker2024\fibre\Attributes\Put;

class PropertyDetailsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/propertydetailslist[/{id}]", [PermissionMiddleware::class], "list.property_details")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyDetailsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/propertydetailsadd[/{id}]", [PermissionMiddleware::class], "add.property_details")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyDetailsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/propertydetailsview[/{id}]", [PermissionMiddleware::class], "view.property_details")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyDetailsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/propertydetailsedit[/{id}]", [PermissionMiddleware::class], "edit.property_details")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyDetailsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/propertydetailsdelete[/{id}]", [PermissionMiddleware::class], "delete.property_details")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PropertyDetailsDelete");
    }
}
